<?php

namespace UtillzCore\Inc\Src\Explore;

use \UtillzCore\Inc\Src\Traits\Singleton;
use \UtillzCore\Inc\Src\Request\Request;

class Query {

    use Singleton;

    public $posts_per_page;
    public $page;
    public $query = [];
    public $meta_query = [
        'relation' => 'OR'
    ];

    // Explicitly declared properties
    public $request;
    public $posts;

    public function __construct() {
        global $ulz_explore;

        $this->request = Request::instance();
        $this->page = $this->request->has('onpage') ? $this->request->get('onpage') : 1;

        if ($ulz_explore->type) {
            $this->posts_per_page = (int) $ulz_explore->type->get('ulz_listings_per_page');
        } else {
            $global_listings_per_page = (int) get_option('ulz_global_listings_per_page');
            $this->posts_per_page = $global_listings_per_page ? $global_listings_per_page : (int) get_option('posts_per_page');
        }
    }

    /*
     * listing sorting
     *
     */
    public function sorting() {

        // default by priority
        return [
            'meta_key' => 'ulz_priority',
            'orderby' => [
                'meta_value_num' => 'DESC',
                'date' => 'DESC',
            ],
            'order' => 'DESC'
        ];

    }

    public function paging() {

        if( $this->request->has('onpage') ) {
            return [
                'offset' => ( $this->page - 1 ) * $this->posts_per_page
            ];
        }

    }

    public function post_title() {

        if( $this->request->has('post_title') ) {
            add_filter( 'posts_where', [ $this, 'where_title' ], 10, 2 );
            return [
                'ulz_search_post_title' => $this->request->get('post_title')
            ];
        }

    }

    public function post_content() {

        if( $this->request->has('post_content') ) {
            add_filter( 'posts_where', [ $this, 'where_content' ], 10, 2 );
            return [
                'ulz_search_post_content' => $this->request->get('post_content')
            ];
        }

    }

    public function collection() {

        if( get_post_type() == 'ulz_collection' ) {
            $this->add_meta_query( 'filters', [
                [
                    'key' => 'ulz_collection',
                    'value' => get_the_ID(),
                ]
            ]);
        }

    }

public function archive() {
    $object = get_queried_object();

    $taxonomies = array(
        'ulz_listing_tag',
        'ulz_listing_region',
        'ulz_listing_category',
        // Add other taxonomy names as needed
    );

    if (is_tax($taxonomies)) {
        $taxonomy = $object->taxonomy;
        $term_id = $object->term_id;

        $this->add_meta_query('filters', [
            [
                'key' => $taxonomy,
                'value' => $term_id,
            ],
        ]);
    }

    // Custom taxonomies
    $custom_taxonomies = Ucore()->get_custom_taxonomies();

    if (is_array($custom_taxonomies)) {
        foreach ($custom_taxonomies as $custom_taxonomy) {
            $taxonomy_slug = Ucore()->prefix($custom_taxonomy->slug);

            if (taxonomy_exists($taxonomy_slug) && is_tax($taxonomy_slug)) {
                $term_id = $object->term_id;

                $this->add_meta_query('filters', [
                    [
                        'key' => $taxonomy_slug,
                        'value' => $term_id,
                    ],
                ]);
            }
        }
    }
}

    public function author() {

        if( is_author() ) {
            $author = get_queried_object();
            $this->add_query([
                'author' => (int) $author->ID
            ]);
        }

    }

    public function get() {

        $this->add_query( $this->sorting() )
        ->add_query( $this->paging() )
        ->add_query( $this->post_title() )
        ->add_query( $this->post_content() )
        ->add_query( $this->collection() )
        ->add_query( $this->archive() )
        ->add_query( $this->author() )
        ->add_query([
            'post_status' => 'publish',
            'post_type' => 'ulz_listing',
            'posts_per_page' => $this->posts_per_page,
            'meta_query' => $this->meta_query,
        ]);

        //dd( $this->query );
        // exit;

    }

    public function add_query( $query ) {

        if( ! $query ) {
            return $this;
        }

        $this->query = array_merge( $this->query, $query );

        return $this;

    }

    public function add_meta_query( $id = null, $meta_query = [], $relation = 'AND' ) {

        if( ! $meta_query ) {
            return $this;
        }

        // main meta query
        if( is_null( $id ) ) {

            $this->meta_query = array_merge( $this->meta_query, $meta_query );
            return $this;

        }

        // sub meta query
        if( ! array_key_exists( $id, $this->meta_query ) ) {
            $this->meta_query[ $id ] = [
                'relation' => $relation
            ];
        }

        $this->meta_query[ $id ] = array_merge( $this->meta_query[ $id ], $meta_query );

        return $this;

    }

    public function fetch() {

        $this->get();

        $this->posts = new \WP_Query( $this->query );
        $this->clear_filters();

    }

    public function clear_filters() {

        remove_filter( 'posts_where', [ $this, 'where_title' ], 10 );
        remove_filter( 'posts_where', [ $this, 'where_content' ], 10 );

    }

    /*
     * search post title
     *
     */
    function where_title( $where, $wp_query ) {

        global $wpdb;

        if( $search_term = $wp_query->get('ulz_search_post_title') ) {
            $where .= " AND {$wpdb->posts}.post_title LIKE '%" . stripslashes( $wpdb->esc_like( $search_term ) ) . "%'";
        }

        return $where;

    }

    /*
     * search post content
     *
     */
    function where_content( $where, $wp_query ) {

        global $wpdb;

        if( $search_term = $wp_query->get('ulz_search_post_content') ) {
            $where .= " AND {$wpdb->posts}.post_content LIKE '%" . stripslashes( $wpdb->esc_like( $search_term ) ) . "%'";
        }

        return $where;

    }


}
